/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validator.AddressValidator.java
 * Desprition : This Validator class is responsible for checking and validating the 
 * Customer Address Information
 * 
 */
package Validators;

import DataClasses.*;
public class UserAddressValidator {
	private String message;

	/**
	 * This method is being used for getting the error message if the validation
	 * is unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used for setting the error message
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validating the address details.
	 * @param addressData The address details to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(UserAddress_Data addressData) {

		UserAddress_Data addressdata = addressData;
		String email, street, city, country, suburb, phoneNumber;

		email = addressdata.getEmail();
		street = addressdata.getStreet();
		city = addressdata.getCity();
		country = addressdata.getCountry();
		suburb = addressdata.getSuburb();
		phoneNumber = addressData.getPhone();

		if (email == null
			|| street == null
			|| city == null
			|| country == null
			|| suburb == null) {
			message = "Some of the required address fields are empty.";
			return false;
		}
		if (!isValidEmailAddress(email)) {
			//message = "The email address is invalid.";
			return false;
		}

		if (!street.matches("^[a-zA-Z/(/)0-9/-/,/./// ]{1,100}+$")) {
			message = "Street has invalid characters.";
			message += " Street must be between 1 and 100 characters long. ";
			return false;
		}
		if (!city.matches("^[a-zA-Z/(/)0-9/-/,/./// ]{1,50}+$")) {
			message = "City has invalid characters.";
			message += " City must be between 1 and 50 characters long. ";
			return false;
		}

		if (!country.matches("^[a-zA-Z/(/)0-9/-/,/./// ]{1,50}+$")) {
			message = "Country has invalid characters.";
			message += " Country must be between 1 and 50 characters long. ";
			return false;
		}

		if (!suburb.matches("^[a-zA-Z/(/)0-9/-/,/./// ]{1,50}+$")) {
			message = "Suburb has invalid characters.";
			message += " Suburb must be between 1 and 50 characters long. ";
			return false;
		}
		if (!phoneNumber.matches("^[/(/)0-9/-/,/./// ]{7,12}+$")) {
			message = "Phone number has invalid characters.";
			message += " Phone number must be between 7 and 12 digits long";
			return false;
		}

		return true;
	}

	/**
	 * This method is being used for validating  a given email address.
	 * @param strEmailAddress The email address to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	private boolean isValidEmailAddress(String strEmailAddress) {

		boolean bValid = true;

		// return false if strEmailAddress is either null or empty
		if (isNullorEmpty(strEmailAddress)) {
			setMessage("Email address is empty.");
			return false;
		}

		// calculate length of the email address
		int iLength = strEmailAddress.length();

		// get the first occurrence of @ char
		int iCharAtPosition = strEmailAddress.indexOf("@");

		// validation fails if @ character is not present 
		if (iCharAtPosition == -1) {
			setMessage("@ character is not found in Email address.");
			bValid = false;
		}
		// validation fails if @ character found is in the first or last position
		else if (
			(iCharAtPosition == 0) || (iCharAtPosition == (iLength - 1))) {
			setMessage("@ character is not allowed to be in the first or last position in Email address.");
			bValid = false;
		}
		// validation fails if more than 1 @ character are present 
		else if (strEmailAddress.indexOf("@", iCharAtPosition + 1) > -1) {
			setMessage("More than 1 @ characters are not allowed in Email address.");
			bValid = false;
		} else {

			// traverse thru all the characters in the given email address
			for (int i = 0; i < iLength; i++) {

				// get the character at the i position
				char c = strEmailAddress.charAt(i);

				if (c == '.') {
					// validation fails if . character found is in the first or last position
					if ((i == 0) || (i == (iLength - 1))) {
						setMessage(". character is not allowed in the first or the last postion in Email address.");
						bValid = false;
						break;
					}
					// . character cannot come before @ character
					else if (i == (iCharAtPosition - 1)) {
						setMessage(". character cannot immediately precede @ character in Email address.");
						bValid = false;
						break;
					}
				}
				// all these are invalid characters
				else if (
					c > '~'
						|| c < '!'
						|| c == '('
						|| c == ')'
						|| c == '<'
						|| c == '>'
						|| c == '['
						|| c == ']'
						|| c == ','
						|| c == ';'
						|| c == ':'
						|| c == '\\'
						|| c == '"') {
					setMessage(
						"Invalid character " + c + " found in Email address.");
					bValid = false;
					break;
				}
			}
		}
		// return the validation flag 
		return bValid;
	}
	
	/**
	 * This method is being used for checking whether the given string is null
	 * or empty.
	 * @param s The string to be checked.
	 * @return boolean Specifies whether the validation was successful.
	 */
	private static boolean isNullorEmpty(String s) {
		if (s == null || s.length() == 0) {
			return true;
		}
		return false;
	}
}
